<?php
include('../config/connect.php');

// Retrieve the form data
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $cat_name = $_POST['cat_name'] ?? '';
 

    // Check if an image file was uploaded
    if (isset($_FILES["image"]) && $_FILES["image"]["error"] === UPLOAD_ERR_OK) {
        $image = $_FILES["image"]["name"];
        $image_tmp = $_FILES["image"]["tmp_name"];
        $upload_dir = "../app_api/images/"; // Specify the directory where you want to store the uploaded images
        move_uploaded_file($image_tmp, $upload_dir . $image);
    } else {
        $image = ''; // Set a default value for the image if no file was uploaded
    }

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Prepare and bind a parameterized statement
    $sql = "INSERT INTO ads_category (cat_name, image) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die("Error: " . $conn->error);
    }

    $stmt->bind_param("ss", $cat_name, $image);

    if ($stmt->execute()) {
        echo '<script>
            setTimeout(function () { 
                swal({
                    title: "Done!",
                    text: " Successfully!",
                    type: "success",
                    confirmButtonText: "OK"
                },
                function(isConfirm){
                    if (isConfirm) {
                        window.history.back();
                    }
                }); }, 1000);
        </script>';
    } else {
        echo '<script>
            setTimeout(function () { 
                swal({
                    title: "Oops!",
                    text: "Something went wrong!",
                    type: "error",
                    confirmButtonText: "OK"
                },
                function(isConfirm){
                    if (isConfirm) {
                        window.history.back();
                    }
                }); }, 1000);
        </script>';
    }
}
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.css">
<script src="https://code.jquery.com/jquery-2.1.3.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert-dev.js"></script>
