<?php
include('../config/connect.php');

// Retrieve the form data
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $title = $_POST['title'] ?? '';
    $full_text = $_POST['full_text'] ?? '';
 
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Prepare and bind a parameterized statement
    $sql = "INSERT INTO notification (title, full_text) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die("Error: " . $conn->error);
    }

    $stmt->bind_param("ss", $title, $full_text);

    if ($stmt->execute()) {
        echo '<script>
            setTimeout(function () { 
                swal({
                    title: "Done!",
                    text: " Successfully!",
                    type: "success",
                    confirmButtonText: "OK"
                },
                function(isConfirm){
                    if (isConfirm) {
                        window.history.back();
                    }
                }); }, 1000);
        </script>';
    } else {
        echo '<script>
            setTimeout(function () { 
                swal({
                    title: "Oops!",
                    text: "Something went wrong!",
                    type: "error",
                    confirmButtonText: "OK"
                },
                function(isConfirm){
                    if (isConfirm) {
                        window.history.back();
                    }
                }); }, 1000);
        </script>';
    }
}
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.css">
<script src="https://code.jquery.com/jquery-2.1.3.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert-dev.js"></script>
